<?php
function resizeImage($sourcePath, $targetPath, $maxSize = 256) {
    list($width, $height, $type) = getimagesize($sourcePath);
    $scale = $maxSize / max($width, $height);
    $newWidth = intval($width * $scale);
    $newHeight = intval($height * $scale);

    $srcImage = imagecreatefromstring(file_get_contents($sourcePath));
    $dstImage = imagecreatetruecolor($newWidth, $newHeight);
    imagecopyresampled($dstImage, $srcImage, 0, 0, 0, 0, $newWidth, $newHeight, $width, $height);

    imagepng($dstImage, $targetPath);
    imagedestroy($srcImage);
    imagedestroy($dstImage);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['image'])) {
    $file = $_FILES['image'];
    if ($file['size'] > 4 * 1024 * 1024) {
        die("Image too large (max 4MB).");
    }

    $uploadPath = 'uploads/temp_image.png';
    move_uploaded_file($file['tmp_name'], $uploadPath);

    $resizedPath = 'uploads/resized.png';
    resizeImage($uploadPath, $resizedPath);

    $imageData = file_get_contents($resizedPath);

    $curl = curl_init('https://api.fluffle.xyz/v1/search');
    curl_setopt_array($curl, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            "User-Agent: api-demo/1.0 (by NoppesTheFolf on Twitter)",
        ],
        CURLOPT_POSTFIELDS => [
            'file' => new CURLFile($resizedPath, 'image/png', 'image.png'),
            'platforms[]' => 'fur affinity',
            'platforms[]' => 'furry network',
            'limit' => 8
        ],
    ]);

    $response = curl_exec($curl);
    curl_close($curl);

    $result = json_decode($response, true);

    echo "<h2>Results:</h2>";
    if (isset($result['results']) && count($result['results']) > 0) {
        foreach ($result['results'] as $item) {
            echo "<div style='margin-bottom:20px'>";
            echo "<img src='{$item['thumbnail']['location']}' width='150'><br>";
            echo "<strong>Match:</strong> {$item['match']}<br>";
            echo "<strong>Platform:</strong> {$item['platform']}<br>";
            echo "<a href='{$item['location']}' target='_blank'>View Source</a><br>";
            if (!empty($item['credits'])) {
                echo "<strong>Credit:</strong> " . htmlspecialchars($item['credits'][0]['name']) . "<br>";
            }
            echo "</div>";
        }
    } else {
        echo "No matches found.";
    }
}
?>
